<?php
/**
 * 404 Monitor Settings Module
 * 
 * @since 2.1
 */

if (class_exists('SEO_Module')) {

class WSW_FofsSettings extends SEO_Module {
	
	static function get_parent_module() { return 'fofs'; }
	static function get_child_order() { return 20; }
	static function is_independent_module() { return false; }
	
	static function get_module_title() { return __('404 Monitor Settings', 'seo-wizard'); }
	function get_module_subtitle() { return __('Settings', 'seo-wizard'); }
	function get_settings_key() { return '404s'; }
	
	function get_default_settings() {
		return array(
			  'exceptions' => "*/favicon.ico\n*/apple-touch-icon.png\n*/pingserver.php\n*/xmlrpc.php"
			, 'max_log_size' => 100
			, 'log_enabled' => $this->flush_setting('log_hits', true, 'settings')
			, 'restrict_logging' => true
			, 'log_spiders' => true
			, 'log_errors_with_referers' => true
		);
	}
	
	function init() {
		add_filter('WSW_get_setting-404s-max_log_size', array('sustr', 'to_int'));
	}
	
	function admin_page_contents() {

		$this->admin_form_start();
		$this->checkbox('log_enabled', __('Continue monitoring for new 404 errors', 'seo-wizard'), __('Monitoring Settings', 'seo-wizard'));
		$this->checkboxes(array(
			  'restrict_logging' => __('Only log these types of 404 errors:', 'seo-wizard')
			, 'log_spiders' => array('description' => __('404s generated by search engine spiders', 'seo-wizard'), 'indent' => true)
			, 'log_errors_with_referers' => array('description' => __('404s with referring URLs', 'seo-wizard'), 'indent' => true)
		), __('Log Restrictions', 'seo-wizard'));
		$this->textbox('max_log_size', __('Maximum Log Entries', 'seo-wizard'), $this->get_default_setting('max_log_size'));
		$this->textarea('exceptions', __('URLs to Ignore', 'seo-wizard') . '<br /><small><em>' . __('(Use * as wildcard)', 'seo-wizard') . '</em></small>', 15);
		$this->admin_form_end();
	}
}

}
?>