(function($){
	
	$(document).ready(function(){
		
		//Focus on search box upon load
		$('#forge-builder-search').focus();
		
		
		//Filter element collection by title 
		$('#forge-builder-search').on('keyup', function(){
			builder_search = $('#forge-builder-search').val().toLowerCase();
			if(builder_search != ''){
				//$('.forge-builder-collection-item').hide();
				$('.forge-builder-collection-item').addClass('forge-builder-collection-hidden');
				$('.forge-builder-collection-item').each(function(){
					if($(this).attr('data-name').toLowerCase().indexOf(builder_search) > -1){
						//$(this).show();
						$(this).removeClass('forge-builder-collection-hidden');
					}
				});
			}else{
				//$('.forge-builder-collection-item').show();
				$('.forge-builder-collection-item').removeClass('forge-builder-collection-hidden');
			}
		});
		
		
		//Selected imagelist field
		$('body').delegate('.forge-imagelist-item', 'click', function(){
			var parent = $(this).parent();
			parent.children('.forge-imagelist-item').each(function(){
				$(this).removeClass('forge-selected');
			});
			$(this).addClass('forge-selected');
		});
		
		
		//Selected iconlist field
		$('body').delegate('.forge-iconlist-item', 'click', function(){
			//Change other borders
			$('.forge-iconlist-item').removeClass('forge-iconlist-selected');
			$(this).addClass('forge-iconlist-selected');        
		});
		
		
		//Margin control field
		$('body').delegate('.forge-margins-control', 'keyup', function(){
			var value = $(this).val();
			$(this).closest('.forge-margins').find('.forge-margins-field').val(value);
			$(this).closest('.forge-margins').find('.forge-margins-field').each(function(){
				$(this).trigger('change');
			});
		});
		
		
		//Select all on click
		$('body').delegate('.forge-click-selectall', 'click', function(){
			$(this).focus();
			$(this).select();
		});
	
	});

})(jQuery);