<?php 

//Elements
function forge_metadata_elements($key = null){
	$data = array();
	
	$data = apply_filters('forge_elements', $data);
	
	//Wrapper - special type
	$data['wrapper'] = array(
	'title' => __('Page Settings', 'forge'),
	'description' => __('The main page wrapper.', 'forge'),
	'hierarchical' => true,
	'parent' => array('page'),
	'callback' => 'forge_element_wrapper',
	'fields' => array(
		array(
		'name' => 'css',
		'label' => __('CSS Styling', 'forge'),
		'type' => 'code',
		'default' => ''),
		
		array(
		'name' => 'background',
		'label' => __('Background Color', 'forge'),
		'type' => 'color',
		'default' => ''),
	));
	
	return isset($key) ? $data[$key] : $data;
}


//Element actions
function forge_metadata_element_actions($key = null){
	$data = array();
	$data = apply_filters('forge_element_actions', $data);
	
	$data['edit'] = array(
	'title' => __('Edit', 'forge'),
	'type' => 'button');
	
	$data['copy'] = array(
	'title' => __('Copy', 'forge'),
	'type' => 'button');
	
	$data['column'] = array(
	'title' => __('Column', 'forge'),
	'type' => 'button');
	
	return isset($key) ? $data[$key] : $data;
}


function forge_metadata_element_settings($key = null){
	$data = array();
	
	$data[] = array(
	'name' => 'element_id',
	'label' => __('Element ID', 'forge'),
	'type' => 'text',
	'default' => '');
		
	$data[] = array(
	'name' => 'element_class',
	'label' => __('Element CSS Classes', 'forge'),
	'type' => 'text',
	'default' => '');
	
	$data[] = array(
	'name' => 'element_margin_bottom',
	'label' => __('Bottom Margin', 'forge'),
	'description' => __('Sets a bottom margin for this element, in pixels.', 'forge'),
	'type' => 'text',
	'placeholder' => '0px',
	'width' => '50px',
	'default' => '24',
	'live' => array(
		'selector' => '.forge-element',
		'property' => 'css',
		'attribute' => 'margin-bottom',
	));
	
	/*$data[] = array(
	'name' => 'element_animation',
	'label' => __('Entrance Animation', 'forge'),
	'type' => 'list',
	'choices' => array(
		'none' => __('(None)', 'forge'),
		'slideup' => __('Slide Upwards', 'forge'),
		'slidedown' => __('Slide Downwards', 'forge'),
		'slideleft' => __('Slide To The Left', 'forge'),
		'slideright' => __('Slide To The Right', 'forge'),
		'zoomin' => __('Zoom In', 'forge'),
		'zoomout' => __('Zoom In', 'forge'),
	),
	'default' => '');*/
		
	$data = apply_filters('forge_common_settings', $data);
	
	return isset($key) ? $data[$key] : $data;
}


function forge_metadata_post_types(){
	//Posts List
	$post_types = get_post_types(array('public' => true), 'objects'); 
	$type_list = array();
	foreach($post_types as $post_type){
		$type_list[$post_type->name] = $post_type->name;
	}
	return $type_list;
}


function forge_metadata_history_actions($action = null, $type = null){
	$data = array(
	'create' => __('Created %s', 'forge'),
	'save' => __('Modified %s', 'forge'),
	'copy' => __('Copied %s', 'forge'),
	'move' => __('Moved %s', 'forge'),
	'delete' => __('Deleted %s', 'forge'),
	'layout' => __('Changed row layout', 'forge'),
	'import' => __('Imported content', 'forge'),
	);
	
	$return = $data;
	if($action != null && $type != null && isset($data[$action])){
		$return = sprintf($data[$action], $type);
	}
	
	return $return;
}


//Buttons on the toolbar
function forge_tools_buttons($key = null){
	$data = array();
	
	$data['settings'] = array('label' => __('Page Settings', 'forge'));
	$data = apply_filters('forge_tools_buttons', $data);
	
	//Help and tools at the bottom
	$data['import'] = array('label' => __('Import', 'forge'));
	$data['export'] = array('label' => __('Export', 'forge'));
	$data['help'] = array('label' => __('Help & Feedback', 'forge'));
	
	return isset($key) ? $data[$key] : $data;
}


//Buttons on the toolbar
function forge_toolbar_buttons($key = null){
	$data = array();
	
	$data['discard'] = array(
	'label' => __('Discard', 'forge'),
	'title' => __('Discard current changes and revert to initial state.', 'forge'),
	'classes' => '');
	
	$data['save'] = array(
	'label' => __('Publish Changes', 'forge'),
	'title' => __('Publish changes to live website.', 'forge'),
	'classes' => '');
	
	$data['close'] = array(
	'title' => __('Exit without publishing. Your changes will be preserved until you return.', 'forge'),
	'classes' => '');
	
	$data = apply_filters('forge_toolbar_buttons', $data);
	
	return isset($key) ? $data[$key] : $data;
}


//Buttons on the toolbar
function forge_row_layouts($key = null){
	$data = array();
	$data['12'] = '12';
	$data['6'] = '6,6';
	$data['4'] = '4,4,4';
	$data['3'] = '3,3,3,3';
	$data['2'] = '2,2,2,2,2,2';
	
	$data = apply_filters('forge_row_layouts', $data);
	
	return isset($key) ? $data[$key] : $data;
}
