<?php
class WSW_Apache_Redirect_File extends WSW_Redirect_File {

	/**
	 * Format URL redirect
	 *
	 * @param $old_url
	 * @param $new_url
	 * @param $type
	 *
	 * @return string
	 */
	public function format_url_redirect( $old_url, $new_url, $type ) {
		$redirect = "Redirect " . $type . " " . $this->add_url_slash( $old_url ) . " " . $this->add_url_slash( $new_url ) . PHP_EOL;

		return $redirect;
	}

	/**
	 * Format REGEX redirect
	 *
	 * @param $regex
	 * @param $url
	 * @param $type
	 *
	 * @return string
	 */
	public function format_regex_redirect( $regex, $url, $type ) {
		return 'RedirectMatch ' . $type . ' ' . $regex . ' ' . $url . PHP_EOL;
	}

	/**
	 * Check if first character is a slash, adds a slash if it ain't so
	 *
	 * @param string $url
	 *
	 * @return string mixed
	 */
	private function add_url_slash( $url ) {

		if ( $url[0] !== '/' ) {
			$url = '/' . $url;
		}

		return $url;
	}

}