<?php
/*
Plugin Name: WordPress SEO Comments Plugin
Plugin URI: http://stallion-theme.co.uk/wordpress-seo-comments-plugin/
Description: WordPress blogs can generate thousands of user comments, but WordPress out the box does nothing SEO wise with comments. After activating the WordPress SEO Comments Plugin and setting up a WordPress template to output your new SEO comments pages, Google will have access to all your users comments and index them in their own right.
Version: 2.2.1
Author: David Law
Author URI: http://stallion-theme.co.uk/
*/
/*
Copyright (C) 2014 David Law (http://stallion-theme.co.uk/ email davidlseo(at)gmail(dot)com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/
// credits 
// http://www.prelovac.com/vladimir/wordpress-plugins/seo-super-comments
// http://scott.sherrillmix.com/blog/blogger/creating-a-better-fake-post-with-a-wordpress-plugin/

// Avoid name collisions.
if ( !class_exists('stseocommentsp') ) :
class stseocommentsp {
	var $DB_option = 'blog-comments-seo';

	function stseocommentsp() {
		add_filter('single_post_title', array(&$this, 'stseocommentsp_post_title'), 10);
		add_action('parse_query', array(&$this, 'parse'));
		add_action('admin_menu', array(&$this, 'stseocommentsp_admin_menu'));
	}
/*
	function stseocommentsp_process_text($text) {
		global $comment, $post; 
		$cid=$comment->comment_ID;
		$anchor=$this->GetExcerpt($text, 4);
		$text=$text.'<div style="float:right"><a href="?cid='.$cid.'">'.$anchor.'</a></div>';
		return ( $text );
	}
*/
	function stseocommentsp_post_title($title) {
		if (isset($_REQUEST['cid'])) {
			$mycomment=get_comment($_REQUEST['cid']);
			$mypost=get_post($mycomment->comment_post_ID);
			return $this->GetExcerpt($mycomment->comment_content, 10);
		}
		else return $title;
	}

	function parse() {
		global $wp_query;
		if (isset($_REQUEST['cid']) > 0) {
			add_action('template_redirect', array(&$this, 'TemplateRedirect'));
		}
	}

	function get_options() {
		$options = array(
		'template'=>'single.php',
		'alsocomment'=>'3',
		'recentcomment'=>'5'
#		'anchor'=>'View Comment'
	);

	$saved = get_option($this->DB_option);

		if (!empty($saved)) {
			foreach ($saved as $key => $option)
			$options[$key] = $option;
		}

		if ($saved != $options)	
		update_option($this->DB_option, $options);
		return $options;
	}

	function install() {
	}

	function stseocommentsp_admin_menu() {
		add_options_page('WordPress SEO Comments Options', 'WordPress SEO Comments', 'manage_options', __FILE__, array(&$this, 'handle_options'));
	}
	
	function GetExcerpt($text, $length = 20 ) {
		$text = strip_tags($text);
		$words = explode(' ', $text, $length + 1);
		if (count($words) > $length) {
			array_pop($words);
			$text = implode(' ', $words);
		}	
		return ucfirst($text);
	}

	function get_author_comments($pid, $author, $cid, $email) {
		global $wpdb;
		$options = $this->get_options();
		$alsocomment=$options['alsocomment'];
		$recentcomment=$options['recentcomment'];
		$result='';
		$author=addslashes($author);
		if ( $alsocomment > 0 ) {
			$comments = $wpdb->get_results($wpdb->prepare("SELECT comment_author, comment_author_url, comment_content, comment_post_ID, comment_ID, comment_author_email FROM $wpdb->comments WHERE comment_approved = '1' AND comment_author_email ='%s' AND comment_post_ID = '$pid' AND NOT comment_ID='$cid' ORDER BY comment_date_gmt DESC LIMIT $alsocomment",$email)); 
			if ( $comments ) {
				$result.='<h3>'.$author.' Also Commented</h3>';
				$result.="<div>";
				foreach ($comments as $comment) {
					$result.='<p><a href="'. esc_url( get_comment_link($comment->comment_ID),null,'display' ) . '">' . get_the_title($comment->comment_post_ID) . '</a><br />'.$comment->comment_content.'</p><hr>';
				}
				$result.="</div>";
			}
		}
		if ( $recentcomment > 0 ) {
			$comments = $wpdb->get_results($wpdb->prepare("SELECT comment_author, comment_author_url, comment_content, comment_post_ID, comment_ID, comment_author_email FROM $wpdb->comments WHERE comment_approved = '1' AND comment_author_email ='%s' AND NOT comment_post_ID = '$pid' ORDER BY comment_date_gmt DESC LIMIT $recentcomment",$email)); 
			if ( $comments ) {
				$result.='<h4>Recent Comments by '.$author.'</h4>';
				$result.="<div>";
				foreach ($comments as $comment) {
					$result.='<p><a href="'. esc_url( get_comment_link($comment->comment_ID),null,'display' ) . '">' . get_the_title($comment->comment_post_ID) . '</a><br />'.$comment->comment_content.'</p><hr>';
				}
				$result.="</div>";
			}
		}
		return $result.'';
	}
	function CreatePost() {
		$mycomment=get_comment($_REQUEST['cid']);
		$mypost=get_post($mycomment->comment_post_ID);
		$options = $this->get_options();
		$post = new stdClass;
		$post->post_author = 1;
		$post->post_title = $this->GetExcerpt($mycomment->comment_content, 10).' ...';
		$author_link='<span class="ssc_info">Comment on <a href="'.get_permalink($mypost->ID).'">'.$mypost->post_title.'</a> by '.$mycomment->comment_author.'.</span>';
		$author_comments=$this->get_author_comments($mypost->ID,$mycomment->comment_author,$mycomment->comment_ID, $mycomment->comment_author_email);
		$post->post_content ="<p>$author_link</p>".$mycomment->comment_content."<p>$author_comments</p>";
		#$post->ID = $mypost->ID;
		$post->ID = -1;
		$post->post_status = 'static';
		$post->comment_status = 'closed';
		$post->ping_status = 'closed';
		$post->comment_count = 0;
		$post->post_date = current_time('mysql');
		$post->post_date_gmt = current_time('mysql', 1);
		add_filter( 'wpseo_canonical', '__return_false' );
		remove_action('wp_head', 'rel_canonical');
		remove_action('wp_head', 'wp_shortlink_wp_head');
		remove_action('wp_head', 'rsd_link');
		remove_action('wp_head', 'start_post_rel_link');
		remove_action('wp_head', 'wlwmanifest_link');
		remove_action('wp_head', 'index_rel_link');
		add_action('wp_head', 'strseo_comment_canonicals');
		return $post;
	}
	function TemplateRedirect() {
		global $wp_query;
		$options = $this->get_options();
		$page=$options['template'];
		$post=$this->CreatePost();
		$wp_query->posts = array();
		$wp_query->post_count = 0;
		$wp_query->posts[] = $post;
		$wp_query->post_count = 1;
		if (locate_template($page) != '') {
			$page = str_replace('.php', '', $page);
			get_template_part($page);
		} else {
			get_template_part('index');
		}
		die();
	}
	function handle_options() {
		$options = $this->get_options();
		if ( isset($_POST['submitted']) ) {
			check_admin_referer('blog-comments-seo');
			$options['template']=$_POST['template'];
			$options['alsocomment']=$_POST['alsocomment'];
			$options['recentcomment']=$_POST['recentcomment'];
#			$options['anchor']=$_POST['anchor'];
			update_option($this->DB_option, $options);
			echo '<div class="updated fade"><p>Plugin settings saved.</p></div>';
	}
	$action_url = $_SERVER['REQUEST_URI'];
	$template=$options['template'];
	$alsocomment=$options['alsocomment'];
	$recentcomment=$options['recentcomment'];
#	$anchor=$options['anchor'];
	$nonce=wp_create_nonce('blog-comments-seo');
echo '<div class="stwpseo">
<h1>WordPress SEO Comments Plugin</h1>
<div style="max-width:900px;">

<div style="float:left; width:490px;">
<div class="dbx-content">
<form name="SEOSC" action="'.$action_url.'" method="post">
<input type="hidden" id="_wpnonce" name="_wpnonce" value="'.$nonce.'" />
<input type="hidden" name="submitted" value="1" /> 
<h2>Plugin Overview</h2>
<p>The WordPress SEO Comments Plugin automatically turn your comments into post like pages that are indexable in search engines like Google. With a highly commented WordPress blog this gives Google hundreds and even thousands of unique web pages to spider and index potentially increasing search engine traffic.</p>
<label for="alsocomment">Authorname Also Commented:</label>
<input style="border:1px solid #D1D1D1; width:30px;" id="alsocomment" name="alsocomment" value="'.$alsocomment.'"/> Comments to show on the same post.
<br /><label for="recentcomment">Recent Comments by Authorname:</label>
<input style="border:1px solid #D1D1D1; width:30px;" id="recentcomment" name="recentcomment" value="'.$recentcomment.'"/> Comments to show on all posts.
<br />Set the above options to 0 if you want to hide the additional comments from the same author.
<br /><br /><label for="template">Template File:</label>
<input style="border:1px solid #D1D1D1; width:165px;"  id="template" name="template" value="'.$template.'"/> Advanced Use and Optional';
/*echo '<br /><label for="anchor">Link Anchor Text:</label>
<input style="border:1px solid #D1D1D1; width:165px;"  id="anchor" name="anchor" value="'.$anchor.'"/>'; */
echo '<div class="submit"><input type="submit" name="Submit" value="Update options" class="button-primary" /></div>
</form>
<h3>Optional: How to Create/Modify a Template File</h3>
<p>For more control over the output you could create a new template files for your theme and reference it above. Since all themes are different it\'s impossible to give instructions that will work with every theme, but the instructions below for TwentyFourteen will point you in the right direction. Note: this is optional, NOT required, some themes will output features you might not want on the comment pages and the instructions below are generally how to remove them.</p>
<p>The basic procedure involves making a copy of your themes single.php template files (download to your computer), rename it single-2.php followed by modifying the file (as described below) in a txt editor (Notepad for example) and upload to your themes folder (using FTP: Filezilla for example) under /wp-content/themes/themename/. And set Template File above to single-2.php.</p>
<h3>Example TwentyFourteen Instructions</h3>
<p>Using FTP (Filezilla for example), download a copy of the single.php file from /wp-content/themes/twentyfourteen/.</p>
<p>On your computer rename single.php to single-2.php</p>
<p>Edit single-2.php in a text editor</p>
<p>Find this code: lines 29 to 31:</p>
<p><pre>if ( comments_open() || get_comments_number() ) {<br />comments_template();<br />}</pre></p>
<p>Change to:</p>
<p><pre>#if ( comments_open() || get_comments_number() ) {<br />#comments_template();<br />#}</pre></p>
<p>This is disabling comments code on the comments pages the plugin outputs, I\'ve used the comment code as an example because the plugin already disables comments, so it\'s just an example of how to comment out code using the sharp sign (#). You could for example comment out the code on line 26: "twentyfourteen_post_nav();" which adds the Next and Previous post links.</p>
<p></p>
<p>The above covers minimum modifications for TwentyFourteen. There\'s a lot you can achieve SEO wise with this plugin concept, but for full SEO benefit it requires significant theme modification. For example with the <a href="http://stallion-theme.co.uk/stallion-responsive-theme/" target="_blank">Stallion Responsive Theme</a> that uses a more SEO advanced built in version of this plugin with multiple SEO modifications builtin, for example Comment Titles that are used as the Title tags for the comment pages.</p>
</div>
</div>

<div style="float:left; width:400px;">
<h3>WordPress SEO Comments Support</h3>
<p>For plugin support please go to the <a href="http://stallion-theme.co.uk/wordpress-seo-comments-plugin/" target="_blank">WordPress SEO Comments Support Page</a>. The WordPress.org support forum system does NOT inform plugin authors of new support requests, basically to know you need help I\'d have to regularly login to the WordPress support forum (could be days or weeks for a response).</p><p>Comments left on my site above result in instant email notification: you could have a response within hours.</p>

<h4>Screenshot of Blog Comment Links</h4>
<p>The image below shows the links to the comment pages generated by the plugin.</p>
<img src="'.plugins_url('blog-comments-seo').'/seo-comments-links.jpg">
</div>

<h4 style="clear:both;"><a href="http://stallion-theme.co.uk/">WordPress Plugins by David Law</a></h4>
</div>

</div>';
	}

}

endif; 

function strseo_comment_canonicals() {
	global $comment;
	$mycomment=get_comment($_REQUEST['cid']);
	$mypost=get_post($mycomment->comment_post_ID);
	$cid=$_REQUEST['cid'];
	$canonical = get_permalink($mypost->ID).'?cid='.$cid.'';
	echo "<link rel=\"canonical\" href=\"" . esc_url($canonical) . "\" />\n";
}
function stallion_sc_link2($content) {
	global $comment;
	$anchor='View Comment';
	$cid=$comment->comment_ID;
	$postpermalink = get_permalink().'?cid='.$cid.'';
	$link='<small><a class="alignright" href="' . esc_url($postpermalink) . '">' . $anchor . '</a></small>';
	return $content.$link;
}
if (!is_admin() ) {
	add_filter('comment_text', 'stallion_sc_link2', 99);
}
if ( class_exists('stseocommentsp') ) :
	if (isset($_REQUEST['cid'])) {
		$cid=$_REQUEST['cid'];
		$comments = get_comments(array(
		'comment__in' => $cid,
		'post_status' => 'publish',
		'status' => 'approve',
		'type' => 'comment',
		));
	if ($comments) {
		$stseocommentsp = new stseocommentsp();
	}
	}
	if (is_admin() ) {
		$stseocommentsp = new stseocommentsp();
	}
	if (isset($stseocommentsp)) {
		register_activation_hook( __FILE__, array(&$stseocommentsp, 'install') );
	}
endif;
?>